/*
 * SharedData.java
 *
 * Created on October 25, 2004, 11:43 AM
 */
import java.util.Random;

/**
 *
 * @author  garbi
 */
public class SharedData {
    public int sharedInt;
    public float sharedFloat;
    public static Random rand= new Random();
    
    public SharedData(int sharedInt, float sharedFloat) {
        this.sharedInt= sharedInt;
        this.sharedFloat= sharedFloat;
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        SharedData data= new SharedData(0, 0);
        ReaderWriter rw= new ReaderPriority();
        int READERS= 5;
        int WRITERS= 3;
        Thread[] all= new Thread[READERS + WRITERS];
        
        for (int i= 0; i < READERS; i++) {
            SomeReaderThread reader= new SomeReaderThread(("R" + i), data, rw);
            
            all[i]= reader;
        }
        
        for (int i= 0; i < WRITERS; i++) {
            SharedData newData= new SharedData(i, i);
            SomeWriterThread writer= new SomeWriterThread(("W" + i), data, newData, rw);
            all[READERS + i]= writer;
        }
        
        StringBuffer order= new StringBuffer();
        for (int i= 0; i < all.length; i++) {
            order.append(all[i].getName()).append(" ");
            all[i].start();
        }
        System.out.println("\n\n-> Start order: " + order + "\n");
    }
}

class SomeWriterThread extends Thread {
    private ReaderWriter rw;
    private SharedData data;
    private SharedData newData;
    public SomeWriterThread(String name, SharedData data, SharedData newData, ReaderWriter rw) {
        super(name);
        this.data= data;
        this.newData= newData;
        this.rw= rw;
    }
    
    public void run() {
        try{
            while (true) {
                rw.startWrite();
                data.sharedInt= newData.sharedInt;
                data.sharedFloat= newData.sharedFloat;
                System.out.println(getName() + " wrote: " + newData.sharedInt + " = " + newData.sharedFloat);
                rw.endWrite();
                sleep(SharedData.rand.nextInt(6000));                
            }
        } catch (Exception e) { System.err.println(e); System.exit(1); }
    }
}

class SomeReaderThread extends Thread {
    private ReaderWriter rw;
    private SharedData data;
    public SomeReaderThread(String name, SharedData data, ReaderWriter rw) {
        super(name);
        this.data= data;
        this.rw= rw;
    }
    
    public void run() {
        try{
            while (true) {
                rw.startRead();
                System.out.println(getName() + " read:  " + data.sharedInt + " = " + data.sharedFloat);
                rw.endRead();
                sleep(SharedData.rand.nextInt(2000));
            }
        } catch (Exception e) { System.err.println(e); System.exit(1); }
    }
}
